/**
 * @file
 * This is part of a patch to address a jQueryUI bug.  The bug is responsible
 * for the inability to scroll a page when a modal dialog is active. If the content
 * of the dialog extends beyond the bottom of the viewport, the user is only able
 * to scroll with a mousewheel or up/down keyboard keys.
 *
 * @see http://bugs.jqueryui.com/ticket/4671
 * @see https://bugs.webkit.org/show_bug.cgi?id=19033
 * @see views_ui.module
 * @see js/jquery.ui.dialog.min.js
 *
 * This JavaScript patch overwrites the $.ui.dialog.overlay.events object to remove
 * the mousedown, mouseup and click events from the list of events that are bound
 * in $.ui.dialog.overlay.create
 *
 * The original code for this object:
 * $.ui.dialog.overlay.events: $.map('focus,mousedown,mouseup,keydown,keypress,click'.split(','),
 *  function(event) {
 *    return event + '.dialog-overlay';
 *  }).join(' '),
 */

(function ($, undefined) {
  if ($.ui && $.ui.dialog && $.ui.dialog.overlay) {
    $.ui.dialog.overlay.events = $.map('focus,keydown,keypress'.split(','),
      function(event) {
        return event + '.dialog-overlay';
      }).join(' ');
  }
}(jQuery));
