jCarousel - Riding carousels with jQuery
========================================

jCarousel is a jQuery plugin for controlling a list of items in horizontal or
vertical order. It provides a full-featured and flexible toolset for navigating
any HTML based content in a carousel-like fashion.

**Note**: Version 0.3.x and 0.2.x are **not** compatible. Old versions can be
downloaded from the [release page](https://github.com/jsor/jcarousel/releases).

Documentation
-------------

The documentation can be found [here](http://sorgalla.com/jcarousel/docs/).

### Reference

  * [Installation](http://sorgalla.com/jcarousel/docs/reference/installation.html)
  * [Configuration](http://sorgalla.com/jcarousel/docs/reference/configuration.html)
  * [API](http://sorgalla.com/jcarousel/docs/reference/api.html)
  * [Usage](http://sorgalla.com/jcarousel/docs/reference/usage.html)
  * [Events](http://sorgalla.com/jcarousel/docs/reference/events.html)

### Plugins

By default, the jCarousel core only contains the minimum functionality needed to
create carousel widgets. Specialized features are provided through plugins.

jCarousel comes with the following plugins:

  * [Control Plugin](http://sorgalla.com/jcarousel/docs/plugins/control/)
  * [Pagination Plugin](http://sorgalla.com/jcarousel/docs/plugins/pagination/)
  * [Autoscroll Plugin](http://sorgalla.com/jcarousel/docs/plugins/autoscroll/)
  * [ScrollIntoView Plugin](http://sorgalla.com/jcarousel/docs/plugins/scrollintoview/)

#### Third-Party Plugins

* [jcarouselSwipe](https://github.com/snake-345/jcarouselSwipe) - Adds support for user-friendly swipe gestures.
* [jcarouselLazyLoading](https://github.com/snake-345/jcarouselLazyLoading) - Adds lazy loading to jcarousel.
* [jcarouselFade](https://github.com/snake-345/jcarouselFade) - New method for support fade animation to jcarousel.
* [jcarousel-status](https://github.com/fzoccara/jcarousel-status) - Display the status of your carousel.
* [jcarousel-smoothscroll](https://github.com/aduth/jcarousel-smoothscroll) - Animates a jCarousel at a constant pace, regardless of varying item widths.

Download
--------

All ready-to-use files are located in the [`dist/`](dist/) directory.

The [`jquery.jcarousel.js`](dist/jquery.jcarousel.js?raw=1) and
[`jquery.jcarousel.min.js`](dist/jquery.jcarousel.min.js?raw=1) files contain
the core and all plugins concenated together.

All files are also available from [CDNJS](http://cdnjs.com/libraries/jcarousel).

Examples
--------

You can find some example implementations in the [`examples/`](examples/)
directory. You can also browse the [functional tests](test/functional/) to get
an impression of how to setup jCarousel.

Credits
-------

jCarousel is written on top of [jQuery](http://jquery.com) and was originally
inspired by the [Carousel Component](http://billwscott.com/carousel/) by
[Bill Scott](http://looksgoodworkswell.com).

License
-------

Copyright (c) 2006-2016 Jan Sorgalla.
Released under the [MIT](LICENSE?raw=1) license.
