/*
 * Thumbnail hover preview script by M.Kleine-Albers / www.artwaves.de
 *
 * What it does: Loads bigger preview images if a user hoves over a thumbnailimage
 * Checks if an image would be loaded outside of the viewport TOP, BOTTOM, LEFT, RIGHT
 * With low resolutions like 1024 its not perfect using big preview images.
 */

(function ($) {

  Drupal.behaviors.HoverPreview = {
    attach:function (context) {

      /* CONFIG GLOBAL vars*/
      //determine popup's additional distance from the cursor
      yOffset = 30;
      xOffset = 10;
      /* END CONFIG */

      /******************************* HOVER *****************************************************/

      $("img.hover-preview").hoverIntent(showPreview, hidePreview);

      function showPreview(e) {

        //GET the TITLE attribute
        this.t = this.title;
        this.title = "";
        var image_title = (this.t != "") ? "<br/>" + this.t : "";

        //get position of hovered element
        var element = $(this);
        var elementPositions = element.offset();
        var thumbWidth = element.outerWidth(true);
        var thumbHeight = element.outerHeight(true);

        /*GLOBAL vars*/
        preview_link = $(this).attr('data-hover-preview'); //Get the src of the bigger preview imagezz
        zoom_link = $(this).attr('data-hover-zoom'); //Get the src of the ZOOM image

        // PRELOADING the zoom image
        preloaded_zoom = $('<img/>').attr('src', zoom_link);

        //Output of the preview element with image
        $("body").append("<div id='image-preview-active'><img src='" + preview_link + "' alt='Loading ...' />" +
                           "<span id='zoom-text'>" + Drupal.t("Press and hold Z key to zoom") + "</span>" +
                           "<span id='title-text'>" + image_title + "</span>" +
                         "</div>");


        //CHECK IF ELEMENT WOULD BE LOADED OUT OF THE VIEWPORT
        //width & height of the popup with the larger image triggered on hover.
        var elementHeight = $("#image-preview-active").outerHeight(true);
        var elementWidth = $("#image-preview-active").outerWidth(true);

        //set initial and change in "if" later if neccessary. The image is loaded there x/y
        var yPosition = elementPositions.top - (elementHeight / 2) + (thumbHeight / 2); //subtraction for centering the preview to thumb
        var xPosition = elementPositions.left + thumbWidth + xOffset; //add with to load it next to hovered thumb

        //Size of the viewport, meaning the area of the page, that is completely visible.
        var winHeight = $(window).height();
        var winWidth = $(window).width();

        //If the page has been scolled, addidtional calculation must be done.
        //Scroll position is the same as the number of pixels that are hidden from view above the scrollable area.
        //If the scroll bar is at the very top, or if the element is not scrollable, this number will be 0.
        var scrolledPixelTop = $(window).scrollTop();
        var scrolledPixelLeft = $(window).scrollLeft();  //a site should not be vertically scrollable, but maybe...
        //console.log('scrolledPixelTop ' + scrolledPixelTop + ',scrolledPixelLeft ' + scrolledPixelLeft);

        //calculate the space that the image needs to displayed next to the thumb image TOP, LEFT, BOTTOM,RIGHT
        //the width that is avaliable for displaying, could be smaller that the needed width

        var calcHeightTop = yPosition;
        var calcHeightBottom = yPosition + elementHeight - scrolledPixelTop;
        var calcHeightLeft = xPosition - elementWidth;
        var calcWidthRight = xPosition + thumbWidth + elementWidth + scrolledPixelLeft;


        //HEIGHT, Y
        //if it would be loaded out of view TOP
        if (calcHeightTop < scrolledPixelTop) {
          var yPosition = scrolledPixelTop;
        }

        //if it would be loaded out of view BOTTOM
        if (calcHeightBottom > winHeight) {
          var yPosition = winHeight - elementHeight + scrolledPixelTop;
        }


        //WIDTH, X

        var rightOut = false; //needed, because on small pixelwidth BOTH if would be called.

        //if it would be loaded out of view RIGHT
        if (calcWidthRight > winWidth) {
          var xPosition = xPosition - elementWidth - thumbWidth - 2 * xOffset + scrolledPixelLeft;
          rightOut = true;
        }

        //if it would be loaded out of view LEFT
        //This is an attempt not to let an image be loaded out of LEFT, but on low res, this is not possible to avoid
        //NO Offset to decrease pixels needed.
        if (calcHeightLeft < scrolledPixelLeft && rightOut == true) {
          var xPosition = xPosition + elementWidth + thumbWidth;
        }

        //Output and place preview image
        $("#image-preview-active")
          .css("top", (yPosition) + "px")
          .css("left", (xPosition) + "px")
          .fadeIn('fast');
      }


      /* hide on mosue move out*/
      function hidePreview() {
        this.title = this.t;
        $("#image-preview-active").remove();
      }

      /**************************** KEY PRESS TO ZOOM *********************************************/

      $(window).keydown(function (e) {
        if (e.which == 90) { // 90 is z Key
          $("#image-preview-active img").attr("src", zoom_link);
        }
      });

      $(window).keyup(function (e) {
        if (e.which == 90) {
          //change image to zoomed image-> output it to the code via module, then code here
          $("#image-preview-active img").attr("src", preview_link);
        }
      });
    }

  };

}(jQuery));

