<?php $path = base_path() . drupal_get_path('module', 'pdf_reader'); ?>
<link rel="resource" type="application/l10n" href="<?php print $path . '/js/locale.properties';?>"/>
    <div id="outerContainer">

      <div id="sidebarContainer">
        <div id="toolbarSidebar" class="splitToolbarButton toggled">
          <button id="viewThumbnail" class="toolbarButton group toggled" title="Show Thumbnails" onclick="PDFView.switchSidebarView('thumbs')" tabindex="1" data-l10n-id="thumbs">
             <span data-l10n-id="thumbs_label"><?php print t('Thumbnails'); ?></span>
          </button>
          <button id="viewOutline" class="toolbarButton group" title="Show Document Outline" onclick="PDFView.switchSidebarView('outline')" tabindex="2" data-l10n-id="outline">
             <span data-l10n-id="outline_label"><?php print t('Document Outline'); ?></span>
          </button>
          <button id="viewSearch" class="toolbarButton group hidden" title="Search Document" onclick="PDFView.switchSidebarView('search')" tabindex="3" data-l10n-id="search_panel">
             <span data-l10n-id="search_panel_label"><?php print t('Search Document'); ?></span>
          </button>
        </div>
        <div id="sidebarContent">
          <div id="thumbnailView">
          </div>
          <div id="outlineView" class="hidden">
          </div>
          <div id="searchView" class="hidden">
            <div id="searchToolbar">
              <input id="searchTermsInput" class="toolbarField" onkeydown='if (event.keyCode == 13) PDFView.search()'>
              <button id="searchButton" class="textButton toolbarButton" onclick='PDFView.search()' data-l10n-id="search"><?php print t('Find'); ?></button>
            </div>
            <div id="searchResults"></div>
          </div>
        </div>
      </div>  <!-- sidebarContainer -->

      <div id="mainContainer">
        <div class="toolbar">
          <div id="toolbarContainer">

            <div id="toolbarViewer">
              <div id="toolbarViewerLeft">
                <button id="sidebarToggle" class="toolbarButton" title="Toggle Sidebar" tabindex="4" data-l10n-id="toggle_slider">
                  <span data-l10n-id="toggle_slider_label"><?php print t('Toggle Sidebar'); ?></span>
                </button>
                <div class="toolbarButtonSpacer"></div>
                <div class="splitToolbarButton">
                  <button class="toolbarButton pageUp" title="Previous Page" onclick="PDFView.page--" id="previous" tabindex="5" data-l10n-id="previous">
                    <span data-l10n-id="previous_label"><?php print t('Previous'); ?></span>
                  </button>
                  <div class="splitToolbarButtonSeparator"></div>
                  <button class="toolbarButton pageDown" title="Next Page" onclick="PDFView.page++" id="next" tabindex="6" data-l10n-id="next">
                    <span data-l10n-id="next_label"><?php print t('Next'); ?></span>
                  </button>
                </div>
                <label id="pageNumberLabel" class="toolbarLabel" for="pageNumber" data-l10n-id="page_label"><?php print t('Page'); ?>: </label>
                <input type="number" id="pageNumber" class="toolbarField pageNumber" onchange="PDFView.page = this.value;" value="1" size="4" min="1" tabindex="7">
                </input>
                <span id="numPages" class="toolbarLabel"></span>
              </div>
              <div id="toolbarViewerRight">

                <button id="fullscreen" class="toolbarButton fullscreen" title="Fullscreen" tabindex="11" data-l10n-id="fullscreen" onclick="PDFView.fullscreen();">
                  <span data-l10n-id="fullscreen_label"><?php print t('Fullscreen'); ?></span>
                </button>

                <button id="print" class="toolbarButton print" title="Print" tabindex="13" data-l10n-id="print" onclick="window.print()">
                  <span data-l10n-id="print_label"><?php print t('Print'); ?></span>
                </button>

                <button id="download" class="toolbarButton download" title="Download" onclick="PDFView.download();" tabindex="14" data-l10n-id="download">
                  <span data-l10n-id="download_label"><?php print t('Download'); ?></span>
                </button>
                <!-- <div class="toolbarButtonSpacer"></div> -->
                <a href="#" id="viewBookmark" class="toolbarButton bookmark" title="Current view (copy or open in new window)" tabindex="15" data-l10n-id="bookmark"><span data-l10n-id="bookmark_label"><?php print t('Current View'); ?></span></a>
              </div>
              <div class="outerCenter">
                <div class="innerCenter" id="toolbarViewerMiddle">
                  <div class="splitToolbarButton">
                    <button class="toolbarButton zoomOut" title="Zoom Out" onclick="PDFView.zoomOut();" tabindex="8" data-l10n-id="zoom_out">
                      <span data-l10n-id="zoom_out_label"><?php print t('Zoom Out'); ?></span>
                    </button>
                    <div class="splitToolbarButtonSeparator"></div>
                    <button class="toolbarButton zoomIn" title="Zoom In" onclick="PDFView.zoomIn();" tabindex="9" data-l10n-id="zoom_in">
                      <span data-l10n-id="zoom_in_label"><?php print t('Zoom In'); ?></span>
                     </button>
                  </div>
                  <span id="scaleSelectContainer" class="dropdownToolbarButton">
                     <select id="scaleSelect" onchange="PDFView.parseScale(this.value);" title="Zoom" oncontextmenu="return false;" tabindex="10" data-l10n-id="zoom">
                      <option id="pageAutoOption" value="auto" selected="selected" data-l10n-id="page_scale_auto"><?php print t('Automatic Zoom'); ?></option>
                      <option id="pageActualOption" value="page-actual" data-l10n-id="page_scale_actual"><?php print t('Actual Size'); ?></option>
                      <option id="pageFitOption" value="page-fit" data-l10n-id="page_scale_fit"><?php print t('Fit Page'); ?></option>
                      <option id="pageWidthOption" value="page-width" data-l10n-id="page_scale_width"><?php print t('Full Width'); ?></option>
                      <option id="customScaleOption" value="custom"></option>
                      <option value="0.5">50%</option>
                      <option value="0.75">75%</option>
                      <option value="1">100%</option>
                      <option value="1.25">125%</option>
                      <option value="1.5">150%</option>
                      <option value="2">200%</option>
                    </select>
                  </span>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div id="viewerContainer">
          <div id="viewer"></div>
        </div>

        <div id="loadingBox">
          <div id="loading"></div>
          <div id="loadingBar"><div class="progress"></div></div>
        </div>

        <div id="errorWrapper" hidden='true'>
          <div id="errorMessageLeft">
            <span id="errorMessage"></span>
            <button id="errorShowMore" onclick="" oncontextmenu="return false;" data-l10n-id="error_more_info">
              <?php print t('More Information'); ?>
            </button>
            <button id="errorShowLess" onclick="" oncontextmenu="return false;" data-l10n-id="error_less_info" hidden='true'>
              <?php print t('Less Information'); ?>
            </button>
          </div>
          <div id="errorMessageRight">
            <button id="errorClose" oncontextmenu="return false;" data-l10n-id="error_close">
              <?php print t('Close'); ?>
            </button>
          </div>
          <div class="clearBoth"></div>
          <textarea id="errorMoreInfo" hidden='true' readonly="readonly"></textarea>
        </div>
      </div> <!-- mainContainer -->

    </div> <!-- outerContainer -->
    <div id="printContainer"></div>