/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Modernizr) {
  var isIE11 = Modernizr.mq('(-ms-high-contrast: active), (-ms-high-contrast: none)');

  if (isIE11) {
    var quickEditLabelObserver = null;
    Drupal.editors.ckeditor5 = {
      attach: function attach(element) {
        var editorMessageContainer = document.createElement('div');
        element.parentNode.insertBefore(editorMessageContainer, element);
        var editorMessages = new Drupal.Message(editorMessageContainer);
        editorMessages.add(Drupal.t('Internet Explorer 11 user: a rich text editor is available for this field when used with any other supported browser.'), {
          type: 'warning'
        });
      },
      detach: function detach() {
        var quickEditToolbar = document.querySelector('#quickedit-entity-toolbar .quickedit-toolbar');

        if (quickEditToolbar) {
          quickEditToolbar.classList.remove('ck5-ie11');
          quickEditToolbar.classList.add('icon-pencil');
          quickEditLabelObserver.disconnect();
        }
      },
      onChange: function onChange() {},
      attachInlineEditor: function attachInlineEditor(element) {
        var quickEditToolbar = document.querySelector('#quickedit-entity-toolbar .quickedit-toolbar');
        var notEditableAlert = Drupal.t('Field Not Editable');
        var notEditableMessage = Drupal.t('CKEditor 5 is not compatible with IE11.');

        function quickEditLabelWarnIE11(toolbarLabel) {
          quickEditLabelObserver.disconnect();
          toolbarLabel.innerHTML = "<div><b>".concat(notEditableAlert, "</b><div>").concat(notEditableMessage, "</div></div>");
          quickEditLabelObserver.observe(toolbarLabel, {
            childList: true
          });
        }

        if (quickEditToolbar) {
          quickEditToolbar.classList.add('ck5-ie11');
          quickEditToolbar.classList.remove('icon-pencil');
          element.classList.add('ck5-ie11');
          var toolbarLabel = quickEditToolbar.querySelector('.quickedit-toolbar-label');
          quickEditLabelObserver = new MutationObserver(function (mutations) {
            for (var i = 0; i < mutations.length; i++) {
              if (mutations[i].type === 'childList') {
                quickEditLabelWarnIE11(toolbarLabel);
              }
            }
          });
          quickEditLabelObserver.observe(toolbarLabel, {
            childList: true
          });
        }
      }
    };
  }
})(Drupal, Modernizr);